<?php
declare(strict_types=1);
if(session_status() === PHP_SESSION_NONE){
  session_set_cookie_params(['httponly'=>true,'samesite'=>'Lax','secure'=>isset($_SERVER['HTTPS'])]);
  session_start();
}
$DB_DIR = __DIR__ . '/_data';
$DB_PATH = $DB_DIR . '/memory.sqlite';
if(!is_dir($DB_DIR)) mkdir($DB_DIR, 0755, true);
function db(){ global $DB_PATH; $pdo = new PDO('sqlite:' . $DB_PATH); $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
  $pdo->exec('CREATE TABLE IF NOT EXISTS messages(id INTEGER PRIMARY KEY AUTOINCREMENT, user TEXT NOT NULL, role TEXT NOT NULL, content TEXT NOT NULL, ts INTEGER NOT NULL)');
  $pdo->exec('CREATE INDEX IF NOT EXISTS idx_user_ts ON messages(user, ts)');
  return $pdo; }
function username_or_guest(){ if(isset($_SESSION['username']) && $_SESSION['username'] !== '') return (string)$_SESSION['username']; if(!isset($_SESSION['guest_id'])) $_SESSION['guest_id'] = 'guest_' . bin2hex(random_bytes(6)); return (string)$_SESSION['guest_id']; }
function json_out($code,$arr){ http_response_code($code); header('Content-Type: application/json; charset=utf-8'); echo json_encode($arr, JSON_UNESCAPED_UNICODE); exit; }
