<?php
header('Content-Type: application/json; charset=utf-8');
function out($c,$a){ http_response_code($c); echo json_encode($a, JSON_UNESCAPED_UNICODE); exit; }
try{
  if($_SERVER['REQUEST_METHOD']!=='POST') out(400,['error'=>'use POST']);
  $raw = file_get_contents('php://input');
  $body = json_decode($raw,true);
  if(!$body || !isset($body['content'])) out(400,['error'=>'content required']);
  $key = null;
  $kfile = __DIR__ . '/.groq';
  if(file_exists($kfile)) $key = trim(file_get_contents($kfile));
  if(!$key) out(500,['error'=>'API key missing (place Groq key in public/api/.groq)']);
  $sys = 'Türkçe konuş. Net, saygılı ve kısa yanıt ver.';
  $spf = __DIR__ . '/system_prompt.txt';
  if(file_exists($spf)){ $tmp = trim(file_get_contents($spf)); if($tmp !== '') $sys = $tmp; }
  $max = isset($_GET['max'])?intval($_GET['max']):1536;
  $messages = [['role'=>'system','content'=>$sys], ['role'=>'user','content'=>$body['content']]];
  $full=''; $finish=null; $round=0;
  do{
    $round++;
    $payload = ['model'=>'llama-3.1-8b-instant','messages'=>$messages,'temperature'=>0.6,'max_tokens'=>$max];
    $json = json_encode($payload, JSON_UNESCAPED_UNICODE);
    $ch = curl_init('https://api.groq.com/openai/v1/chat/completions');
    curl_setopt_array($ch,[
      CURLOPT_RETURNTRANSFER=>true, CURLOPT_POST=>true, CURLOPT_CUSTOMREQUEST=>'POST',
      CURLOPT_HTTPHEADER=>['Content-Type: application/json; charset=utf-8','Accept: application/json','Authorization: Bearer '.$key, 'Expect:'],
      CURLOPT_POSTFIELDS=>$json, CURLOPT_TIMEOUT=>120, CURLOPT_FOLLOWLOCATION=>true, CURLOPT_MAXREDIRS=>3, CURLOPT_HTTP_VERSION=>CURL_HTTP_VERSION_1_1, CURLOPT_SSL_VERIFYPEER=>true
    ]);
    $res = curl_exec($ch); $code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $err = curl_error($ch); curl_close($ch);
    if($res===false || $code==0) out(500,['error'=>'curl_error','detail'=>$err]);
    $dec = json_decode($res,true);
    if(json_last_error()!==JSON_ERROR_NONE) out(500,['error'=>'non_json_response','body'=>$res]);
    $chunk = $dec['choices'][0]['message']['content'] ?? '';
    $finish = $dec['choices'][0]['finish_reason'] ?? null;
    $full .= $chunk;
    if($finish === 'length' && $round < 3){
      $messages[] = ['role'=>'assistant','content'=>$chunk];
      $messages[] = ['role'=>'user','content'=>'Devam et ve kaldığın yerden sürdür.'];
      continue;
    } else break;
  } while(true);
  out(200, ['reply'=>$full,'provider'=>'groq','model'=>'llama-3.1-8b-instant','finish_reason'=>$finish,'rounds'=>$round]);
}catch(Throwable $e){ out(500,['error'=>'php exception','detail'=>$e->getMessage()]); }
?>