(function(){
  const chat = document.getElementById('chat');
  const input = document.getElementById('input');
  const sendBtn = document.getElementById('send');
  const sugg = document.getElementById('suggestions');
  let cfg = { botName:'VARKAN AI', welcomeText:'Ben VARKAN AI. Ne üzerinde çalışıyoruz?', quickPrompts:[] };
  fetch('config.json').then(r=>r.json()).then(c=>{ cfg={...cfg,...c}; document.getElementById('brandName').textContent = cfg.botName || 'VARKAN AI'; if(cfg.quickPrompts && cfg.quickPrompts.length){ cfg.quickPrompts.slice(0,8).forEach(q=>{ const b=document.createElement('button'); b.className='pill'; b.textContent=q; b.onclick=()=>{ input.value=q; input.dispatchEvent(new Event('input')); }; sugg.appendChild(b); }); } });
  const sentinel = document.createElement('div'); sentinel.id='bottom-sentinel'; chat.appendChild(sentinel);
  function snapBottom(){ requestAnimationFrame(()=>{ sentinel.scrollIntoView({block:'end'}); }); }
  input.addEventListener('input', ()=>{ input.style.height='auto'; input.style.height = Math.min(input.scrollHeight,180)+'px'; });
  function row(role, content){
    const item = document.createElement('div'); item.className = 'msg role-'+role;
    const avatar = document.createElement('div'); avatar.className='avatar'; avatar.textContent = role==='user'?'👤':'🤖';
    const wrap = document.createElement('div'); const meta = document.createElement('div'); meta.className='meta'; meta.textContent = role==='user'?'Sen':(cfg.botName||'Asistan');
    const bubble = document.createElement('div'); bubble.className='bubble'; bubble.textContent = content||'';
    wrap.appendChild(meta); wrap.appendChild(bubble); item.appendChild(avatar); item.appendChild(wrap); chat.insertBefore(item, sentinel); snapBottom(); return bubble;
  }
  async function typeInto(node, fullText){
    const speedFast=18, speedSlow=10, chunkSize=3; let i=0;
    while(i < fullText.length){ node.textContent += fullText.slice(i, i+chunkSize); i+=chunkSize; snapBottom(); await new Promise(r=>setTimeout(r, i<200?speedFast:speedSlow)); }
    snapBottom();
  }
  async function send(){ const text = input.value.trim(); if(!text) return; input.value=''; input.dispatchEvent(new Event('input')); row('user', text); sendBtn.disabled=true;
    const assistantBubble = row('assistant','');
    try{
      const res = await fetch('api/chat.php', { method:'POST', headers:{'Content-Type':'application/json'}, body: JSON.stringify({ content: text }) });
      const txt = await res.text(); let data;
      try{ data = JSON.parse(txt); } catch { await typeInto(assistantBubble, 'Sunucu JSON yerine şunu döndürdü:\n' + txt.slice(0,1000)); return; }
      if(data.reply){ await typeInto(assistantBubble, data.reply); } else { await typeInto(assistantBubble, 'Hata: '+(data.error||'')+(data.status?(' status:'+data.status):'')); }
    }catch(e){ await typeInto(assistantBubble, 'İstek hatası: ' + (e?.message || e)); }
    finally{ sendBtn.disabled=false; snapBottom(); }
  }
  sendBtn.addEventListener('click', send);
  input.addEventListener('keydown', (e)=>{ if(e.key==='Enter' && !e.shiftKey){ e.preventDefault(); send(); } });
  setTimeout(()=>{ row('assistant', cfg.welcomeText || 'Merhaba!'); }, 500);
})();